<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/_inc/csrf.php';
include __DIR__ . '/_layout/admin_header.php';

$pdo = db();
$msg = '';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $action = $_POST['action'] ?? '';
  if ($action==='create') {
    $name = trim($_POST['name'] ?? '');
    $slug = slugify($name);
    $sort = (int)($_POST['sort_order'] ?? 0);
    $pdo->prepare("INSERT INTO categories (name,slug,sort_order,is_active) VALUES (?,?,?,1)")->execute([$name,$slug,$sort]);
    $msg = 'Kategori eklendi.';
  }
  if ($action==='delete') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
    $msg = 'Kategori silindi.';
  }
  if ($action==='toggle') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("UPDATE categories SET is_active = 1 - is_active WHERE id=?")->execute([$id]);
    $msg = 'Durum güncellendi.';
  }
}

$cats = $pdo->query("SELECT * FROM categories ORDER BY sort_order ASC, id DESC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h5 mb-0">Kategoriler</h1>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-4">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2">Yeni Kategori</div>
      <form method="post" class="vstack gap-2">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="create">
        <input class="form-control" name="name" placeholder="Kategori adı" required>
        <input class="form-control" name="sort_order" placeholder="Sıra" type="number" value="0">
        <button class="btn btn-primary">Kaydet</button>
      </form>
    </div>
  </div>

  <div class="col-lg-8">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2">Liste</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead><tr><th>#</th><th>Ad</th><th>Slug</th><th>Sıra</th><th>Durum</th><th></th></tr></thead>
          <tbody>
            <?php foreach($cats as $c): ?>
              <tr>
                <td><?= (int)$c['id'] ?></td>
                <td><?= e($c['name']) ?></td>
                <td class="text-muted small"><?= e($c['slug']) ?></td>
                <td><?= (int)$c['sort_order'] ?></td>
                <td><?= $c['is_active'] ? 'Aktif':'Pasif' ?></td>
                <td class="text-end">
                  <form method="post" class="d-inline">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="toggle">
                    <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">
                    <button class="btn btn-outline-secondary btn-sm">Aktif/Pasif</button>
                  </form>
                  <form method="post" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">
                    <button class="btn btn-outline-danger btn-sm">Sil</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (count($cats)===0): ?>
              <tr><td colspan="6" class="text-muted">Kayıt yok.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/_layout/admin_footer.php'; ?>
