<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/helpers.php';
ensure_session();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';
  $u = login($email, $pass);
  if ($u && ($u['role'] ?? '') === 'admin') {
    header("Location: " . base_url('/admin/index.php'));
    exit;
  }
  $error = 'E-posta veya şifre hatalı.';
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Giriş</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width:520px;">
  <div class="card bg-white border p-4">
    <h1 class="h5 mb-3">Admin Giriş</h1>
    <?php if ($error): ?><div class="alert alert-danger"><?= e($error) ?></div><?php endif; ?>
    <form method="post" class="vstack gap-2">
      <input class="form-control" name="email" placeholder="E-posta" required>
      <input class="form-control" name="password" placeholder="Şifre" type="password" required>
      <button class="btn btn-primary">Giriş</button>
    </form>
    <div class="text-muted small mt-3">Varsayılan: admin@cengizsuaritma.local / admin12345</div>
  </div>
</div>
</body>
</html>
