<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/_inc/csrf.php';
include __DIR__ . '/_layout/admin_header.php';

$pdo = db();
$msg = '';

$cats = $pdo->query("SELECT * FROM categories WHERE is_active=1 ORDER BY sort_order ASC, name ASC")->fetchAll();

$edit_id = (int)($_GET['edit'] ?? 0);
$edit = null;
if ($edit_id > 0) {
  $st = $pdo->prepare("SELECT * FROM products WHERE id=? LIMIT 1");
  $st->execute([$edit_id]);
  $edit = $st->fetch();
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $action = $_POST['action'] ?? '';
  if ($action==='create' || $action==='update') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    if ($slug==='') $slug = slugify($name);
    $sku = trim($_POST['sku'] ?? '');
    $cat = (int)($_POST['category_id'] ?? 0); if ($cat===0) $cat = null;
    $price = (float)str_replace(',', '.', ($_POST['price'] ?? '0'));
    $sale = trim($_POST['sale_price'] ?? '');
    $sale_price = ($sale==='' ? null : (float)str_replace(',', '.', $sale));
    $short = trim($_POST['short_desc'] ?? '');
    $desc = trim($_POST['description'] ?? '');
    $featured = isset($_POST['featured']) ? 1 : 0;
    $active = isset($_POST['is_active']) ? 1 : 0;

    $cover = upload_image('cover_image', 'products');
    if ($action==='create') {
      $stmt = $pdo->prepare("INSERT INTO products (category_id,name,slug,sku,price,sale_price,short_desc,description,featured,is_active,cover_image)
                             VALUES (?,?,?,?,?,?,?,?,?,?,?)");
      $stmt->execute([$cat,$name,$slug,$sku,$price,$sale_price,$short,$desc,$featured,$active,$cover]);
      $msg = 'Ürün eklendi.';
    } else {
      $fields = "category_id=?, name=?, slug=?, sku=?, price=?, sale_price=?, short_desc=?, description=?, featured=?, is_active=?";
      $params = [$cat,$name,$slug,$sku,$price,$sale_price,$short,$desc,$featured,$active];
      if ($cover) { $fields .= ", cover_image=?"; $params[] = $cover; }
      $params[] = $id;
      $stmt = $pdo->prepare("UPDATE products SET $fields WHERE id=?");
      $stmt->execute($params);
      $msg = 'Ürün güncellendi.';
    }
  }

  if ($action==='delete') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM products WHERE id=?")->execute([$id]);
    $msg = 'Ürün silindi.';
  }

  if ($action==='add_image') {
    $id = (int)($_POST['id'] ?? 0);
    $img = upload_image('image', 'products');
    if ($img) {
      $pdo->prepare("INSERT INTO product_images (product_id,image,sort_order) VALUES (?,?,0)")->execute([$id,$img]);
      $msg = 'Görsel eklendi.';
    } else {
      $msg = 'Görsel yüklenemedi.';
    }
  }

  if ($action==='del_image') {
    $imgId = (int)($_POST['image_id'] ?? 0);
    $pdo->prepare("DELETE FROM product_images WHERE id=?")->execute([$imgId]);
    $msg = 'Görsel silindi.';
  }
}

$list = $pdo->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h5 mb-0">Ürünler</h1>
</div>

<?php if ($msg): ?><div class="alert alert-info"><?= e($msg) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2"><?= $edit ? 'Ürün Düzenle' : 'Yeni Ürün' ?></div>
      <form method="post" enctype="multipart/form-data" class="vstack gap-2">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="<?= $edit ? 'update' : 'create' ?>">
        <?php if ($edit): ?><input type="hidden" name="id" value="<?= (int)$edit['id'] ?>"><?php endif; ?>

        <label class="form-label">Ürün adı</label>
        <input class="form-control" name="name" required value="<?= e($edit['name'] ?? '') ?>">

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Slug (opsiyon)</label>
            <input class="form-control" name="slug" value="<?= e($edit['slug'] ?? '') ?>" placeholder="otomatik oluşur">
          </div>
          <div class="col-md-6">
            <label class="form-label">Ürün kodu (SKU)</label>
            <input class="form-control" name="sku" value="<?= e($edit['sku'] ?? '') ?>">
          </div>
        </div>

        <label class="form-label">Kategori</label>
        <select class="form-select" name="category_id">
          <option value="0">Seçiniz</option>
          <?php foreach($cats as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ($edit && (int)$edit['category_id']===(int)$c['id'])?'selected':'' ?>><?= e($c['name']) ?></option>
          <?php endforeach; ?>
        </select>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="form-label">Fiyat</label>
            <input class="form-control" name="price" value="<?= e($edit['price'] ?? '0') ?>">
          </div>
          <div class="col-md-6">
            <label class="form-label">İndirimli fiyat (opsiyon)</label>
            <input class="form-control" name="sale_price" value="<?= e($edit['sale_price'] ?? '') ?>">
          </div>
        </div>

        <label class="form-label">Kısa açıklama</label>
        <input class="form-control" name="short_desc" value="<?= e($edit['short_desc'] ?? '') ?>">

        <label class="form-label">Açıklama</label>
        <textarea class="form-control" name="description" rows="4"><?= e($edit['description'] ?? '') ?></textarea>

        <label class="form-label">Kapak görseli</label>
        <input class="form-control" type="file" name="cover_image" accept=".jpg,.jpeg,.png,.webp">

        <div class="d-flex gap-3 mt-1">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="featured" id="f" <?= ($edit && $edit['featured'])?'checked':'' ?>>
            <label class="form-check-label" for="f">Öne çıkar</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" id="a" <?= (!$edit || ($edit && $edit['is_active']))?'checked':'' ?>>
            <label class="form-check-label" for="a">Aktif</label>
          </div>
        </div>

        <button class="btn btn-primary mt-2"><?= $edit ? 'Güncelle' : 'Kaydet' ?></button>
        <?php if ($edit): ?>
          <a class="btn btn-outline-secondary" href="<?= e(base_url('/admin/products.php')) ?>">Yeni ekle</a>
        <?php endif; ?>
      </form>

      <?php if ($edit): ?>
        <?php
          $imgs = $pdo->prepare("SELECT * FROM product_images WHERE product_id=? ORDER BY id DESC");
          $imgs->execute([(int)$edit['id']]);
          $images = $imgs->fetchAll();
        ?>
        <hr>
        <div class="fw-semibold mb-2">Ürün Galerisi</div>
        <form method="post" enctype="multipart/form-data" class="vstack gap-2">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="action" value="add_image">
          <input type="hidden" name="id" value="<?= (int)$edit['id'] ?>">
          <input class="form-control" type="file" name="image" accept=".jpg,.jpeg,.png,.webp" required>
          <button class="btn btn-outline-primary btn-sm">Görsel ekle</button>
        </form>

        <div class="row g-2 mt-2">
          <?php foreach($images as $im): ?>
            <div class="col-4">
              <img src="<?= e(base_url('/uploads/' . $im['image'])) ?>" class="w-100 rounded-3" style="height:90px;object-fit:cover">
              <form method="post" onsubmit="return confirm('Silinsin mi?')" class="mt-1">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="del_image">
                <input type="hidden" name="image_id" value="<?= (int)$im['id'] ?>">
                <button class="btn btn-outline-danger btn-sm w-100">Sil</button>
              </form>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2">Liste</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead><tr><th>#</th><th>Ürün</th><th>Kategori</th><th>Fiyat</th><th>Durum</th><th></th></tr></thead>
          <tbody>
            <?php foreach($list as $p): ?>
              <tr>
                <td><?= (int)$p['id'] ?></td>
                <td>
                  <div class="fw-semibold"><?= e($p['name']) ?></div>
                  <div class="text-muted small"><?= e($p['sku']) ?></div>
                </td>
                <td class="text-muted small"><?= e($p['category_name'] ?? '-') ?></td>
                <td>
                  <?php if (!empty($p['sale_price'])): ?>
                    <div class="text-muted small"><s><?= number_format((float)$p['price'],2,',','.') ?> TL</s></div>
                    <div class="fw-semibold"><?= number_format((float)$p['sale_price'],2,',','.') ?> TL</div>
                  <?php else: ?>
                    <div class="fw-semibold"><?= number_format((float)$p['price'],2,',','.') ?> TL</div>
                  <?php endif; ?>
                </td>
                <td><?= $p['is_active'] ? 'Aktif':'Pasif' ?></td>
                <td class="text-end">
                  <a class="btn btn-outline-primary btn-sm" href="<?= e(base_url('/admin/products.php?edit=' . (int)$p['id'])) ?>">Düzenle</a>
                  <form method="post" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                    <button class="btn btn-outline-danger btn-sm">Sil</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (count($list)===0): ?>
              <tr><td colspan="6" class="text-muted">Kayıt yok.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/_layout/admin_footer.php'; ?>
