<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/_inc/csrf.php';
include __DIR__ . '/_layout/admin_header.php';

$pdo = db();
$msg = '';
$s = settings();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $site = trim($_POST['site_name'] ?? 'cengizsuaritma');
  $wa = trim($_POST['whatsapp_number'] ?? '');
  $tpl = trim($_POST['whatsapp_template'] ?? '');
  $stmt = $pdo->prepare("UPDATE settings SET site_name=?, whatsapp_number=?, whatsapp_template=? WHERE id=1");
  $stmt->execute([$site,$wa,$tpl]);
  $msg = 'Ayarlar kaydedildi.';
  $s = settings();
}
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h5 mb-0">Ayarlar</h1>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>

<div class="card bg-white border p-3">
  <form method="post" class="vstack gap-2">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <div class="row g-2">
      <div class="col-md-6">
        <label class="form-label">Site adı</label>
        <input class="form-control" name="site_name" value="<?= e($s['site_name']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">WhatsApp numarası</label>
        <input class="form-control" name="whatsapp_number" value="<?= e($s['whatsapp_number']) ?>" placeholder="905xxxxxxxxx">
        <div class="form-text">Sadece rakam önerilir (ör: 905xxxxxxxxx).</div>
      </div>
    </div>
    <label class="form-label mt-2">WhatsApp mesaj şablonu</label>
    <textarea class="form-control" name="whatsapp_template" rows="3"><?= e($s['whatsapp_template']) ?></textarea>
    <div class="form-text">Değişkenler: {urun}, {fiyat}, {sku}</div>
    <button class="btn btn-primary mt-2">Kaydet</button>
  </form>
</div>

<?php include __DIR__ . '/_layout/admin_footer.php'; ?>
