<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/_inc/csrf.php';
include __DIR__ . '/_layout/admin_header.php';

$pdo = db();
$msg = '';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $action = $_POST['action'] ?? '';
  if ($action==='create') {
    $title = trim($_POST['title'] ?? '');
    $subtitle = trim($_POST['subtitle'] ?? '');
    $btnText = trim($_POST['button_text'] ?? 'Detay');
    $btnLink = trim($_POST['button_link'] ?? '#');
    $order = (int)($_POST['sort_order'] ?? 0);
    $img = upload_image('image', 'sliders');
    if (!$img) { $msg = 'Görsel yüklenemedi (jpg/png/webp).'; }
    else {
      $pdo->prepare("INSERT INTO sliders (title,subtitle,image,button_text,button_link,sort_order,is_active) VALUES (?,?,?,?,?,?,1)")
          ->execute([$title,$subtitle,$img,$btnText,$btnLink,$order]);
      $msg = 'Slider eklendi.';
    }
  }
  if ($action==='delete') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM sliders WHERE id=?")->execute([$id]);
    $msg = 'Slider silindi.';
  }
  if ($action==='toggle') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("UPDATE sliders SET is_active = 1 - is_active WHERE id=?")->execute([$id]);
    $msg = 'Durum güncellendi.';
  }
}

$rows = $pdo->query("SELECT * FROM sliders ORDER BY sort_order ASC, id DESC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h5 mb-0">Slider</h1>
</div>

<?php if ($msg): ?><div class="alert alert-info"><?= e($msg) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2">Yeni Slider</div>
      <form method="post" enctype="multipart/form-data" class="vstack gap-2">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="create">
        <input class="form-control" name="title" placeholder="Başlık" required>
        <input class="form-control" name="subtitle" placeholder="Alt başlık">
        <div class="row g-2">
          <div class="col-6"><input class="form-control" name="button_text" placeholder="Buton yazısı" value="Detay"></div>
          <div class="col-6"><input class="form-control" name="button_link" placeholder="Buton linki" value="<?= e(base_url('/public/products.php')) ?>"></div>
        </div>
        <input class="form-control" name="sort_order" type="number" value="0" placeholder="Sıra">
        <input class="form-control" name="image" type="file" accept=".jpg,.jpeg,.png,.webp" required>
        <button class="btn btn-primary">Kaydet</button>
      </form>
      <div class="text-muted small mt-2">Öneri görsel: 1920x600</div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card bg-white border p-3">
      <div class="fw-semibold mb-2">Liste</div>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead><tr><th>#</th><th>Görsel</th><th>Başlık</th><th>Sıra</th><th>Durum</th><th></th></tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td><img src="<?= e(base_url('/uploads/' . $r['image'])) ?>" style="width:90px;height:48px;object-fit:cover;border-radius:10px"></td>
                <td><?= e($r['title']) ?></td>
                <td><?= (int)$r['sort_order'] ?></td>
                <td><?= $r['is_active'] ? 'Aktif':'Pasif' ?></td>
                <td class="text-end">
                  <form method="post" class="d-inline">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="toggle">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <button class="btn btn-outline-secondary btn-sm">Aktif/Pasif</button>
                  </form>
                  <form method="post" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <button class="btn btn-outline-danger btn-sm">Sil</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (count($rows)===0): ?>
              <tr><td colspan="6" class="text-muted">Kayıt yok.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/_layout/admin_footer.php'; ?>
