<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

function auth_user(): ?array {
  ensure_session();
  return $_SESSION['user'] ?? null;
}

function require_login(string $role = ''): void {
  $u = auth_user();
  if (!$u) {
    header("Location: " . ($role==='admin' ? base_url('/admin/login.php') : base_url('/user/login.php')));
    exit;
  }
  if ($role && ($u['role'] ?? '') !== $role) {
    http_response_code(403);
    echo "Yetkisiz erişim.";
    exit;
  }
}

function login(string $email, string $password): ?array {
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id,name,email,phone,password_hash,role FROM users WHERE email=? LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if (!$u) return null;
  if (!password_verify($password, $u['password_hash'])) return null;

  ensure_session();
  unset($u['password_hash']);
  $_SESSION['user'] = $u;
  return $u;
}

function logout(): void {
  ensure_session();
  $_SESSION = [];
  session_destroy();
}

function register_user(string $name, string $email, string $phone, string $password): array {
  $pdo = db();
  $hash = password_hash($password, PASSWORD_BCRYPT);
  $stmt = $pdo->prepare("INSERT INTO users (name,email,phone,password_hash,role) VALUES (?,?,?,?, 'user')");
  $stmt->execute([$name,$email,$phone,$hash]);
  return ['id'=>$pdo->lastInsertId(),'name'=>$name,'email'=>$email,'phone'=>$phone,'role'=>'user'];
}
