<?php
function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function env_cfg(): array { return require __DIR__ . '/../config/.env.php'; }

function base_url(string $path = ''): string {
  $cfg = env_cfg();
  $base = rtrim($cfg['app']['base_url'] ?? '', '/');
  return $base . $path;
}

function slugify(string $text): string {
  $text = mb_strtolower($text, 'UTF-8');
  $map = ['ç'=>'c','ğ'=>'g','ı'=>'i','ö'=>'o','ş'=>'s','ü'=>'u'];
  $text = strtr($text, $map);
  $text = preg_replace('~[^a-z0-9]+~u', '-', $text);
  $text = trim($text, '-');
  return $text ?: 'urun';
}

function settings(): array {
  $pdo = db();
  $row = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch();
  if (!$row) {
    $pdo->exec("INSERT INTO settings (id,site_name,whatsapp_number,whatsapp_template) VALUES (1,'cengizsuaritma','905000000000','Merhaba, {urun} ürününü satın almak istiyorum. Fiyat: {fiyat} TL. Ürün kodu: {sku}')");
    $row = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch();
  }
  return $row;
}

function wa_link(array $product): string {
  $s = settings();
  $num = preg_replace('~[^0-9]~', '', (string)$s['whatsapp_number']);
  $tpl = (string)$s['whatsapp_template'];

  $price = number_format((float)$product['price'], 2, ',', '.');
  if (!empty($product['sale_price'])) {
    $price = number_format((float)$product['sale_price'], 2, ',', '.');
  }

  $msg = strtr($tpl, [
    '{urun}' => (string)$product['name'],
    '{fiyat}' => $price,
    '{sku}' => (string)$product['sku'],
  ]);

  return "https://wa.me/{$num}?text=" . rawurlencode($msg);
}

function upload_image(string $field, string $subdir = ''): ?string {
  if (!isset($_FILES[$field]) || $_FILES[$field]['error'] !== UPLOAD_ERR_OK) return null;

  $cfg = env_cfg();
  $uploadsRoot = rtrim($cfg['app']['uploads_dir'], '/');
  $targetDir = $uploadsRoot . ($subdir ? '/' . trim($subdir,'/') : '');
  if (!is_dir($targetDir)) mkdir($targetDir, 0775, true);

  $tmp = $_FILES[$field]['tmp_name'];
  $name = $_FILES[$field]['name'];
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  $allowed = ['jpg','jpeg','png','webp'];
  if (!in_array($ext, $allowed, true)) return null;

  $filename = date('Ymd_His') . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
  $dest = $targetDir . '/' . $filename;

  if (!move_uploaded_file($tmp, $dest)) return null;

  // Return relative path from uploads root
  $rel = ($subdir ? trim($subdir,'/') . '/' : '') . $filename;
  return $rel;
}

function ensure_session(): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
}
